<?php
require_once __DIR__ . '/../utils/Config.php'; require_once SRC_PATH . '/models/Ad.php'; require_once SRC_PATH . '/classes/LanguageController.php'; class AdController { private $db; private $gameState; public function __construct($db = null, $gameState = null) { if ($db === null) { $this->db = Database::getInstance(); } else { $this->db = $db; } if ($gameState === null) { $this->loadGameState(); } else { $this->gameState = $gameState; } } private function loadGameState() { $this->gameState = $this->db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); } public function generateAdOffers() { $pendingCount = Ad::countPendingAds($this->db); if ($pendingCount >= 3) { return; } if (!$this->canGenerateNewOffer()) { return; } $offersToGenerate = 3 - $pendingCount; for ($i = 0; $i < $offersToGenerate; $i++) { $this->createRandomAdOffer(); } $this->db->query( "UPDATE game_state_meta SET value = NULL WHERE key_name = 'next_offer_time'" ); } private function createRandomAdOffer() { $currentYear = $this->gameState['current_year']; $currentMonth = $this->gameState['current_month']; $adTypes = [Ad::TYPE_BANNER, Ad::TYPE_POPUP]; if ($currentYear >= 2005) { $adTypes[] = Ad::TYPE_MISLEADING; } $type = $adTypes[array_rand($adTypes)]; list($name, $description, $impressions, $creditPerImpression, $months) = $this->generateAdParameters($type, $currentYear); $randomMinutes = mt_rand(10, 30); $expiresAt = date('Y-m-d H:i:s', time() + ($randomMinutes * 60)); $adData = [ 'name' => $name, 'description' => $description, 'type' => $type, 'impression_count' => $impressions, 'credit_per_impression' => $creditPerImpression, 'completion_months' => $months, 'expires_at' => $expiresAt, 'total_credit' => $impressions * $creditPerImpression ]; $ad = new Ad($adData); $ad->save($this->db); return $ad; } private function generateAdParameters($type, $currentYear) { $yearFactor = 1.0; if ($currentYear < 2005) { $yearFactor = 0.5; } else if ($currentYear < 2010) { $yearFactor = 1.0; } else if ($currentYear < 2015) { $yearFactor = 1.5; } else { $yearFactor = 2.0; } switch ($type) { case Ad::TYPE_BANNER: $name = $this->getBannerName(); $description = t('game.ads.banner_description'); $baseImpressions = mt_rand(500, 2000); $impressions = (int)($baseImpressions * $yearFactor); $baseCredit = mt_rand(15, 20) / 100; $creditPerImpression = $baseCredit * $yearFactor; $months = mt_rand(1, 3); return [$name, $description, $impressions, $creditPerImpression, $months]; case Ad::TYPE_POPUP: $name = $this->getPopupName(); $description = t('game.ads.popup_description'); $baseImpressions = mt_rand(300, 1000); $impressions = (int)($baseImpressions * $yearFactor); $baseCredit = mt_rand(30, 40) / 100; $creditPerImpression = $baseCredit * $yearFactor; $months = mt_rand(1, 2); return [$name, $description, $impressions, $creditPerImpression, $months]; case Ad::TYPE_MISLEADING: $name = $this->getMisleadingName(); $description = t('game.ads.misleading_description'); $baseImpressions = mt_rand(100, 500); $impressions = (int)($baseImpressions * $yearFactor); $baseCredit = mt_rand(55, 80) / 100; $creditPerImpression = $baseCredit * $yearFactor; $months = 1; return [$name, $description, $impressions, $creditPerImpression, $months]; default: return [t('game.ads.unknown_ad'), t('game.ads.no_description'), 100, 0.1, 1]; } } private function getBannerName() { $companies = [ t('game.ads.companies.tech_giant'), t('game.ads.companies.game_world'), t('game.ads.companies.web_services'), t('game.ads.companies.fast_net'), t('game.ads.companies.digital_pro'), t('game.ads.companies.cyber_shop'), t('game.ads.companies.net_stream') ]; $products = [ t('game.ads.products.software'), t('game.ads.products.hardware'), t('game.ads.products.service'), t('game.ads.products.vpn'), t('game.ads.products.hosting'), t('game.ads.products.game'), t('game.ads.products.e_commerce') ]; $company = $companies[array_rand($companies)]; $product = $products[array_rand($products)]; return t('game.ads.banner_ad_format', ['company' => $company, 'product' => $product]); } private function getPopupName() { $prefixes = [ t('game.ads.prefixes.special_offer'), t('game.ads.prefixes.last_chance'), t('game.ads.prefixes.amazing_deal'), t('game.ads.prefixes.limited_time'), t('game.ads.prefixes.win_now'), t('game.ads.prefixes.click_win') ]; $topics = [ t('game.ads.topics.software_discount'), t('game.ads.topics.free_trial'), t('game.ads.topics.premium_membership'), t('game.ads.topics.game_credit'), t('game.ads.topics.fast_internet') ]; $prefix = $prefixes[array_rand($prefixes)]; $topic = $topics[array_rand($topics)]; return t('game.ads.popup_ad_format', ['prefix' => $prefix, 'topic' => $topic]); } private function getMisleadingName() { $actions = [ t('game.ads.actions.download'), t('game.ads.actions.click_now'), t('game.ads.actions.win'), t('game.ads.actions.start'), t('game.ads.actions.update') ]; $items = [ t('game.ads.items.free_software'), t('game.ads.items.accelerator'), t('game.ads.items.video_player'), t('game.ads.items.internet_booster'), t('game.ads.items.virus_scanner'), t('game.ads.items.file_downloader') ]; $action = $actions[array_rand($actions)]; $item = $items[array_rand($items)]; return t('game.ads.misleading_ad_format', ['action' => $action, 'item' => $item]); } public function getPendingAds() { $this->expireOldOffers(); return Ad::getPendingAds($this->db); } public function getActiveAds() { return Ad::getActiveAds($this->db); } public function getCompletedAds() { return Ad::getCompletedAds($this->db, 4); } public function acceptAdOffer($adId) { $ad = Ad::getById($this->db, $adId); if (!$ad || !$ad->isPending()) { return [ 'success' => false, 'message' => t('game.ads.offer_not_found_or_processed') ]; } $activeAds = $this->getActiveAds(); if (count($activeAds) >= 3) { return [ 'success' => false, 'message' => t('game.ads.max_active_campaigns_limit') ]; } $bannerCount = 0; $popupCount = 0; $misleadingCount = 0; foreach ($activeAds as $activeAd) { switch ($activeAd->getType()) { case Ad::TYPE_BANNER: $bannerCount++; break; case Ad::TYPE_POPUP: $popupCount++; break; case Ad::TYPE_MISLEADING: $misleadingCount++; break; } } switch ($ad->getType()) { case Ad::TYPE_BANNER: if ($bannerCount >= 2) { return [ 'success' => false, 'message' => t('game.ads.max_banner_limit') ]; } break; case Ad::TYPE_POPUP: if ($popupCount >= 1) { return [ 'success' => false, 'message' => t('game.ads.max_popup_limit') ]; } break; case Ad::TYPE_MISLEADING: if ($misleadingCount >= 1) { return [ 'success' => false, 'message' => t('game.ads.max_misleading_limit') ]; } break; } $currentYear = $this->gameState['current_year']; $currentMonth = $this->gameState['current_month']; $ad->setStartDate($currentYear, $currentMonth); $endMonth = $currentMonth + $ad->getCompletionMonths(); $endYear = $currentYear; if ($endMonth > 12) { $endMonth = $endMonth - 12; $endYear += 1; } $ad->setEndDate($endYear, $endMonth); $ad->setStatus(Ad::STATUS_ACCEPTED); $ad->save($this->db); return [ 'success' => true, 'message' => t('game.ads.offer_accepted_success'), 'ad' => $ad ]; } public function rejectAdOffer($adId) { $ad = Ad::getById($this->db, $adId); if (!$ad || !$ad->isPending()) { return [ 'success' => false, 'message' => t('game.ads.offer_not_found_or_processed') ]; } $ad->setStatus(Ad::STATUS_REJECTED); $ad->save($this->db); $randomMinutes = mt_rand(3, 10); $nextOfferTime = date('Y-m-d H:i:s', time() + ($randomMinutes * 60)); $existingTime = $this->db->query( "SELECT value FROM game_state_meta WHERE key_name = 'next_offer_time'" )->fetchColumn(); if ($existingTime) { $this->db->query( "UPDATE game_state_meta SET value = ? WHERE key_name = 'next_offer_time'", [$nextOfferTime] ); } else { $this->db->query( "INSERT INTO game_state_meta (key_name, value) VALUES (?, ?)", ['next_offer_time', $nextOfferTime] ); } $this->cleanupOldAds(); return [ 'success' => true, 'message' => t('game.ads.offer_rejected_success'), 'next_offer_in_minutes' => $randomMinutes ]; } private function cleanupOldAds() { $this->db->query( "DELETE FROM ads WHERE is_accepted IN (?, ?) AND created_at < datetime('now', '-7 days')", [Ad::STATUS_REJECTED, Ad::STATUS_CANCELLED] ); } private function canGenerateNewOffer() { $nextOfferTime = $this->db->query( "SELECT value FROM game_state_meta WHERE key_name = 'next_offer_time'" )->fetchColumn(); if (!$nextOfferTime || strtotime($nextOfferTime) <= time()) { return true; } return false; } public function getMinutesUntilNextOffer() { $nextOfferTime = $this->db->query( "SELECT value FROM game_state_meta WHERE key_name = 'next_offer_time'" )->fetchColumn(); if (!$nextOfferTime) { return 0; } $nextOfferTimestamp = strtotime($nextOfferTime); $now = time(); if ($nextOfferTimestamp <= $now) { return 0; } return ceil(($nextOfferTimestamp - $now) / 60); } public function cancelAdCampaign($adId) { $ad = Ad::getById($this->db, $adId); if (!$ad || !$ad->isActive()) { return [ 'success' => false, 'message' => t('game.ads.active_campaign_not_found') ]; } $penalty = $ad->calculateCancellationPenalty(); $this->gameState['credits'] -= $penalty; $this->db->query( "UPDATE game_state SET credits = ? WHERE id = 1", [$this->gameState['credits']] ); $ad->setStatus(Ad::STATUS_CANCELLED); $ad->save($this->db); return [ 'success' => true, 'message' => t('game.ads.campaign_cancelled_with_penalty', ['penalty' => number_format($penalty, 2)]), 'penalty' => $penalty ]; } public function updateAdImpressions() { $this->loadGameState(); if ($this->gameState['server_online'] == 0) { return [ 'credits_earned' => 0, 'satisfaction_effect' => 0, 'server_offline' => true ]; } $activeAds = $this->getActiveAds(); if (empty($activeAds)) { return; } $currentVisitors = $this->gameState['current_visitors']; if ($currentVisitors <= 0) { return; } $totalSatisfactionEffect = 0; $totalCredits = 0; foreach ($activeAds as $ad) { $impressions = max(1, floor($currentVisitors / 10)); $remainingImpressions = $ad->getRemainingImpressions(); $actualImpressions = min($impressions, $remainingImpressions); if ($actualImpressions > 0) { $ad->increaseImpressions($actualImpressions); $earnings = $actualImpressions * $ad->getCreditPerImpression(); $totalCredits += $earnings; $satisfactionEffect = $ad->getVisitorSatisfactionEffect() * $actualImpressions; $totalSatisfactionEffect += $satisfactionEffect; $ad->save($this->db); if ($ad->isCompleted()) { $this->logAdCompleted($ad); } } } if ($totalCredits > 0) { $this->gameState['credits'] += $totalCredits; $this->db->query( "UPDATE game_state SET credits = ? WHERE id = 1", [$this->gameState['credits']] ); } if ($totalSatisfactionEffect != 0) { $newSatisfaction = $this->gameState['visitor_satisfaction'] + ($totalSatisfactionEffect / 100); $newSatisfaction = max(0.1, min(1.0, $newSatisfaction)); $this->db->query( "UPDATE game_state SET visitor_satisfaction = ? WHERE id = 1", [$newSatisfaction] ); } return [ 'credits_earned' => $totalCredits, 'satisfaction_effect' => $totalSatisfactionEffect ]; } private function logAdCompleted($ad) { $message = t('game.ads.campaign_completed_log', [ 'name' => $ad->getName(), 'credits' => number_format($ad->getTotalCredit(), 2) ]); $this->addEventLog('success', $message); } private function addEventLog($type, $message) { $time = date('H:i'); $this->db->query( "INSERT INTO event_log (type, message, event_time) VALUES (?, ?, ?)", [$type, $message, $time] ); } public function checkExpiredCampaigns() { $activeAds = $this->getActiveAds(); $currentYear = $this->gameState['current_year']; $currentMonth = $this->gameState['current_month']; $expiredAds = []; foreach ($activeAds as $ad) { if ($ad->isExpired($currentYear, $currentMonth)) { $penalty = $ad->calculateCancellationPenalty(); $this->gameState['credits'] -= $penalty; $ad->setStatus(Ad::STATUS_CANCELLED); $ad->save($this->db); $this->addEventLog('danger', t('game.ads.campaign_expired_log', [ 'name' => $ad->getName(), 'penalty' => number_format($penalty, 2) ])); $expiredAds[] = [ 'ad' => $ad, 'penalty' => $penalty ]; } } if (!empty($expiredAds)) { $this->db->query( "UPDATE game_state SET credits = ? WHERE id = 1", [$this->gameState['credits']] ); } return $expiredAds; } private function expireOldOffers() { $now = date('Y-m-d H:i:s'); $this->db->query( "UPDATE ads SET is_accepted = ? WHERE is_accepted = ? AND expires_at < ?", [Ad::STATUS_REJECTED, Ad::STATUS_PENDING, $now] ); } public function calculateCancellationPenalty($adId) { $ad = Ad::getById($this->db, $adId); if (!$ad || !$ad->isActive()) { return [ 'success' => false, 'message' => 'Aktif reklam kampanyası bulunamadı.' ]; } $penalty = $ad->calculateCancellationPenalty(); return [ 'success' => true, 'penalty' => $penalty, 'ad_id' => $adId, 'completion_percentage' => $ad->getCompletionPercentage() ]; } } 